﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using Gemini.Core.WinForms.Base;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.Competence
{
    public partial class UCTabCompetenceCompetenceParts : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        private BL.BO.CompetencePart.Search _paramSearch = null;
        private Gemini.Core.WinForms.Controls.GDataManager<BL.BO.View.CompetencePart, BL.BO.CompetencePart.Search> _GDataManagerCompetenceParts = null;

        internal BL.BO.CompetencePart.Search ParamSearch
        {
            get
            {
                if (_paramSearch == null)
                {
                    _paramSearch = new BL.BO.CompetencePart.Search();
                }

                _paramSearch.CompetenceID = UCDetails.DataManager.Current.ID;

                return _paramSearch;
            }
        }

        internal Gemini.Core.WinForms.Controls.GDataManager<BL.BO.View.CompetencePart, BL.BO.CompetencePart.Search> DataManagerCompetenceParts
        {
            get
            {
                if (_GDataManagerCompetenceParts == null)
                {

                    _GDataManagerCompetenceParts = new Gemini.Core.WinForms.Controls.GDataManager<BL.BO.View.CompetencePart, BL.BO.CompetencePart.Search>("ZestawyKompetencjSladowych", _gDataGridViewExercise);
                }

                return _GDataManagerCompetenceParts;
            }
        }

        private void OnMove(Gemini.Core.WinForms.Controls.GDataManagerMoveArgs<BL.BO.View.CompetencePart> Args)
        {
            if (DataManagerCompetenceParts.Current != null)
            {
                    Args.Success = UCDetails.BLZSBELearning.CompetencePart.Switch(Args.Object, Args.ObjectTo);

                    foreach (BL.BO.View.CompetencePart _loopCompetencePart in DataManagerCompetenceParts.GetObjectCollection())
                    {
                        _loopCompetencePart.Weight = UCDetails.BLZSBELearning.CompetencePart.View.Restore(_loopCompetencePart).Weight;
                    } 
            }
        }

        private void OnDelete(Gemini.Core.WinForms.Controls.GDataManagerDeleteArgs<BL.BO.View.CompetencePart> Args)
        {
            if (UCDetails.DataManager.Current != null)
            {
                Args.Success = UCDetails.BLZSBELearning.CompetencePart.Remove(Args.Object).Success;

                DataManagerCompetenceParts.Refresh(null, null); 
            }
        }

        private BL.BO.View.CompetencePart OnCreate(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            if (UCDetails.DataManager.Current != null)
            {
                CompetencePart.FNewCompetencePart _dialogNew = Gemini.Core.WinForms.Base.Form.Create<CompetencePart.FNewCompetencePart>(UCDetails.Plugin, Environment);
                _dialogNew.Initialize(UCDetails.DataManager.Current, UCDetails.Plugin, Environment);

                if (_dialogNew.ShowDialog() == DialogResult.OK)
                {
                    if (_dialogNew.NewCompetencePart != null)
                    {
                        return UCDetails.BLZSBELearning.CompetencePart.View.Restore(_dialogNew.NewCompetencePart);
                    }
                }
            }
            return null;
        }

        private IList<BL.BO.View.CompetencePart> OnLoadData(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            return  UCDetails.BLZSBELearning.CompetencePart.View.Restore(ParamSearch);
        }

        public UCTabCompetenceCompetenceParts()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCCompetenceDetails UCDetails
        {
            get { return (UCCompetenceDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            _gDataGridViewExercise.CellDoubleClick += new DataGridViewCellEventHandler(CellDoubleClick);

            DataManagerCompetenceParts.SaveMode = Gemini.Core.WinForms.Controls.GDataManagerSaveMode.SelectedObject;
            DataManagerCompetenceParts.AllowedActions = Gemini.Core.WinForms.Controls.Type.ControlActionType.New | Gemini.Core.WinForms.Controls.Type.ControlActionType.Delete | Gemini.Core.WinForms.Controls.Type.ControlAction.Move | Gemini.Core.WinForms.Controls.Type.ControlActionType.Refresh;
            DataManagerCompetenceParts.InitColumns(new string[] { "Weight", "ID", "Name"});//Przetłumaczone
            DataManagerCompetenceParts.ColumnCaptions = new string[] { Gemini.Dictionary.Text.Grid.LP.Value, Gemini.Dictionary.Text.Grid.ID.Value, Gemini.Dictionary.Text.Grid.Name.Value};

            DataManagerCompetenceParts.OnLoadData += new Gemini.Core.WinForms.Controls.GDataManagerListEventHandler<BL.BO.View.CompetencePart>(OnLoadData);
            DataManagerCompetenceParts.OnCreate += new Gemini.Core.WinForms.Controls.GDataManagerCreateObjectEventHandler<BL.BO.View.CompetencePart>(OnCreate);
            DataManagerCompetenceParts.OnDelete += new Gemini.Core.WinForms.Controls.GDataManagerDeleteObjectEventHandler<BL.BO.View.CompetencePart>(OnDelete);
            DataManagerCompetenceParts.OnMove += new Gemini.Core.WinForms.Controls.GDataManagerMoveEventHandler<BL.BO.View.CompetencePart>(OnMove);

            UCDetails.DataManager.SetChild(DataManagerCompetenceParts);
        }

        private void CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            Environment.WindowsHandler.Show(Plugin.Name, new Gemini.Core.WinForms.Base.AccessDescription(BL.Dictionary.Objects.UI.CompetencePartEdit), new PI.FM.N000.Base.WinForms.Classes.Param(DataManagerCompetenceParts.Current));           
        }

        public override void DoRestore()
        {
            if (UCDetails.DataManager.Current != null)
            {
                DataManagerCompetenceParts.LoadData();

                BL.BO.CompetencePart.Search _search = new BL.BO.CompetencePart.Search();
                _search.CompetenceID = UCDetails.DataManager.Current.ID;
            }
        }
    }
}
